function slideShow() {
	this.contentID   = 'slideshow'; // slideshow layer
	this.imgPaths    = [];
	this.imgWidth    = 320;
	this.imgHeight   = 240;
	this.useBorders  = true; // td borders - set 'false' for no borders
	this.borderWidth = 1; // td border width - px
	this.borderColor = '#000000'; // td border color
	this.slideSpeed  = 1500;
	this.hideNav     = true; // hide navigation
	this.hideImages  = true; // hide images after scroll
}
slideShow.prototype.ajax = function( dataUrl ) {
  var thisObj = this;
	thisObj.ajaxobj = createAjaxObj();
	if (thisObj.ajaxobj ) {
		var url = dataUrl + "?bustcache=" + new Date().getTime();
		thisObj.ajaxobj.onreadystatechange = function() { thisObj.ajaxinit(); }
		thisObj.ajaxobj.open( 'GET', url, true );
		thisObj.ajaxobj.send( null );
	}
}
slideShow.prototype.ajaxinit = function() {
  var thisObj = this;
  if ( thisObj.ajaxobj.readyState == 4 ) {
		if ( thisObj.ajaxobj.status == 200 || window.location.href.indexOf("http") == -1 ) {
			try { eval( "thisObj.imgPaths = "+ this.ajaxobj.responseText +";" ); }
			catch (e) { thisObj.imgPaths = []; }
			if ( window.attachEvent ) { 
				window.attachEvent( "onunload", function() { thisObj.imgPaths = thisObj.ajaxobj = null; } ); }
			thisObj.init();
		}
  }
}
slideShow.prototype.init = function() {
	var thisObj = this;
	thisObj.slideOK   = false;
	thisObj.objCount  = thisObj.imgPaths.length; // images
	thisObj.images    = new Array(); // create imagelist
	thisObj.images[0] = null;
	for(i=1; i<=thisObj.objCount+1; i++) { 
	 thisObj.images[i] = { 'path':[thisObj.imgPaths[i-1]], 'shown':false } 
	}
	thisObj.contentdiv = document.getElementById( thisObj.contentID );
	thisObj.xPos = 1; // init position
	thisObj.slideBy = ( thisObj.useBorders ) ? thisObj.borderWidth + thisObj.imgWidth : thisObj.imgWidth;
	// init table
  var initTable = '<'+'table border="0" cellpadding="0" cellspacing="0" height="' + thisObj.imgHeight + '"><'+'tr>';
	for (i=1; i<=thisObj.objCount; i++) {
		initTable += '<'+'td id="' + thisObj.contentID + i + '"';
		if ( thisObj.useBorders ) { 
		  initTable += ' style="border-right:' + thisObj.borderWidth + 'px solid ' + thisObj.borderColor + '"'; 
		}
		initTable += '><' + 'div class="dummy">loading image ' + i + ' ... <'+'/div><'+'/td>';
	}
	initTable += '<'+'/tr><'+'/table>';
	document.getElementById( thisObj.contentID ).innerHTML = initTable;
  thisObj.slideobj = new dynObj( thisObj.contentID, 0, 0 ); // init slideobject
	thisObj.slideobj.show();
	thisObj.preload( thisObj.xPos ); // preload img 1,2,3
	thisObj.show( thisObj.xPos );    // show img 1
	thisObj.show( thisObj.xPos+1 );  // show img 2
	thisObj.checkNav(); // check Nav
	thisObj.slideOK = true;
}
slideShow.prototype.slide = function( direction ) { 
	var thisObj = this;
	var newPos = null;
	if ( ! thisObj.slideOK ) { return; }
	
	// scroll right
	if ( thisObj.xPos < thisObj.objCount && direction == 'right' ) { 
		thisObj.xPos += 1;
		newPos = ( (thisObj.xPos-1) * thisObj.slideBy ) * -1;
		// preload & show
		if ( thisObj.xPos < thisObj.objCount && ! thisObj.images[ thisObj.xPos+1 ].shown ) { 
			thisObj.preload( thisObj.xPos+1 );
  		thisObj.show( thisObj.xPos+1 );
		}
		// hide
		if ( thisObj.hideImages && thisObj.xPos > 2 && thisObj.images[ thisObj.xPos-2 ].shown ) {
		  thisObj.hide( thisObj.xPos-2 );
		}
	}
	// scroll left
	if ( thisObj.xPos > 1 && direction=='left' ) { 
		thisObj.xPos -= 1;
		newPos = ( (thisObj.xPos-1) * thisObj.slideBy ) * -1;
		// show
		if ( thisObj.hideImages && thisObj.xPos > 1 && ! thisObj.images[ thisObj.xPos-1 ].shown ) { 
  		thisObj.show( thisObj.xPos-1 );
		}
		// hide
		if ( thisObj.hideImages && thisObj.xPos+2 < thisObj.objCount && thisObj.images[ thisObj.xPos+2 ].shown ) {
		  thisObj.hide( thisObj.xPos+2 );
		}
	}
	// do scroll
	if ( newPos!=null ) { 
		thisObj.slideobj.slideTo( newPos, 0, thisObj.slideSpeed, -1 );
		thisObj.checkNav();
	}
}
slideShow.prototype.preload = function( pos ) { 
  var thisObj = this;
	var lCount = ( pos+2<=thisObj.objCount ) ? pos+2 : thisObj.objCount;
	for( i=pos; i<=lCount; i++ ) {
	  thisObj.images[ i ].img = new Image();
  	thisObj.images[ i ].img.src = thisObj.images[ i ]['path'];
	}
}
slideShow.prototype.show = function( pos ) {
  var thisObj = this;
	if ( ! thisObj.images[ pos ].img || ! thisObj.images[ pos ].img.complete ) { 
		thisObj.t1 = setTimeout( function() { thisObj.show( pos ) }, 200 );
  }
	else if( ! thisObj.images[ pos ].shown ) {
	  var content = '<'+'div class="slide"><'+'img src="' + thisObj.images[ pos ].img.src;
		content += '" width="' + thisObj.imgWidth + '" height="' + thisObj.imgHeight;
		content += '" border="0" /><'+'/div>';
	  document.getElementById( thisObj.contentID+pos ).innerHTML = content; 
	  thisObj.images[ pos ].shown = true;
	}
}
slideShow.prototype.hide = function( pos ) {
  var thisObj = this;
	if( thisObj.images[ pos ].shown ) {
	  var content = '<' + 'div class="dummy">image ' + pos + '<' + '/div>';
		document.getElementById( thisObj.contentID+pos ).innerHTML = content;
		thisObj.images[ pos ].shown = false;
	}	
}
slideShow.prototype.checkNav = function() {
  var thisObj = this;
	if ( ! thisObj.hideNav ) { return; }
	var vis1 = ( thisObj.xPos == thisObj.objCount ) ? 'hidden' : 'visible';
	document.getElementById( thisObj.contentID+'_next' ).style.visibility=vis1;
	var vis2 = ( thisObj.xPos == 1 ) ? 'hidden' : 'visible';
	document.getElementById( thisObj.contentID+'_prev' ).style.visibility=vis2;
}

// Ajax
function createAjaxObj() {
	request = ( window.XMLHttpRequest ) ? new XMLHttpRequest() : new ActiveXObject( "MSXML2.XMLHTTP" );
	return request;
}

// Slider
dynObj.holder = {}; 
function dynObj(id,x,y,w,h) {
  var el = dynObj.getElemRef(id);
  if (!el) return;  this.id = id; 
  dynObj.holder[this.id] = this; this.animString = "dynObj.holder." + this.id;
  var px = window.opera? 0: "px";
	this.x = x || 0;	if (x) el.style.left = this.x + px;
	this.y = y || 0;	if (y) el.style.top = this.y + px;
	this.w = w || el.offsetWidth || 0;	this.h = h || el.offsetHeight || 0;
	if (w) el.style.width = w + px; if (h) el.style.height = h + px;
}
dynObj.prototype.slideTo = function (destX,destY,slideDur,acc,endFn) {
  if (!document.getElementById) return;
  this.slideDur = slideDur || .0001; var acc = -acc || 0;
  if (endFn) this.onSlideEnd = endFn;
 	if (destX == null) this.destX = this.x;	else this.destX = destX;
  if (destY == null) this.destY = this.y; else this.destY = destY;
  this.startX = this.x; this.startY = this.y;
	this.st = new Date().getTime();
  this.xc1 = this.x + ( (1+acc) * (this.destX-this.x)/3 );
	this.xc2 = this.x + ( (2+acc) * (this.destX-this.x)/3 );
  this.yc1 = this.y + ( (1+acc) * (this.destY-this.y)/3 );
	this.yc2 = this.y + ( (2+acc) * (this.destY-this.y)/3 );
	this.sliding = true;
  this.onSlideStart();
  dw_Animation.add(this.animString + ".doSlide()");
}
dynObj.prototype.shiftTo = function(x,y) {
  var el = this.el? this.el: dynObj.getElemRef(this.id)? dynObj.getElemRef(this.id): null;
  if (el) {
    if (x != null) el.style.left = (this.x = x) + "px";
    if (y != null) el.style.top = (this.y = y) + "px";
  }
}
dynObj.prototype.show = function() { 
  var el = this.el? this.el: dynObj.getElemRef(this.id)? dynObj.getElemRef(this.id): null;
  if (el) el.style.visibility = "visible"; 
}
dynObj.prototype.hide = function() { 
  var el = this.el? this.el: dynObj.getElemRef(this.id)? dynObj.getElemRef(this.id): null;
  if (el) el.style.visibility = "hidden"; 
}
dynObj.prototype.doSlide = function() {
	if (!this.sliding) return;	
	var elapsed = new Date().getTime() - this.st;
	if (elapsed < this.slideDur) {
    var x = dw_Bezier.getValue(elapsed/this.slideDur, this.startX, this.destX, this.xc1, this.xc2);
    var y = dw_Bezier.getValue(elapsed/this.slideDur, this.startY, this.destY, this.yc1, this.yc2);
		this.shiftTo( Math.round(x) ,Math.round(y) );
		this.onSlide();
	} else {
    dw_Animation.remove(this.animString + ".doSlide()");
		this.shiftTo(this.destX,this.destY);
		this.onSlide();
		this.sliding = false;
		this.onSlideEnd();
	}
}
dynObj.prototype.onSlideStart = function () {}
dynObj.prototype.onSlide = function () {}
dynObj.prototype.onSlideEnd = function () { if (this.el) this.el = null; }
dynObj.getElemRef = function(id) { 
  var el = document.getElementById? document.getElementById(id): null;
  return el;
} 
dw_Animation = {
  instances: [],
  add: function(fp) {
    this.instances[this.instances.length] = fp;
  	if (this.instances.length == 1) this.timerID = window.setInterval("dw_Animation.control()", 10);
  },
  remove: function(fp) {
    for (var i = 0; this.instances[i]; i++) {
  		if (fp == this.instances[i]) {
  			this.instances = this.instances.slice(0,i).concat( this.instances.slice(i+1) );
  			break;
  		}
  	}
  	if (this.instances.length == 0) {
  		window.clearInterval(this.timerID);	this.timerID = null;
  	}
  },
  control: function() {
    for (var i = 0; this.instances[i]; i++) {
  		if (typeof this.instances[i] == "function" ) this.instances[i]();
      else eval(this.instances[i]);
    }
  }
}
var dw_Bezier = {
  B1: function (t) { return t*t*t },
  B2: function (t) { return 3*t*t*(1-t) },
  B3: function (t) { return 3*t*(1-t)*(1-t) },
  B4: function (t) { return (1-t)*(1-t)*(1-t) },
  getValue: function (percent,startVal,endVal,c1,c2) {
    return endVal * this.B1(percent) + c2 * this.B2(percent) + c1 * this.B3(percent) + startVal * this.B4(percent);
  }
}